package require  psfgen
package require  pbctools
package require  topotools
package require  autoionize

proc build_sys { {name_1 } {name_2} } {
    set  id_1   [mol new $name_1.psf waitfor all]
    mol addfile $name_1.pdb waitfor all
    
    set  id_2   [mol new $name_2.psf waitfor all]
    mol addfile $name_2.pdb waitfor all
    
    set all [atomselect $id_2 all]
    set center [measure  center $all]
    puts "Center: $center"
    $all  moveby [vecscale -1 $center]
    
    set center [measure  center $all]
    puts "Center: $center"
    $all delete
    set idlist  {}
    lappend idlist $id_1 $id_2
    set new [::TopoTools::mergemols  $idlist]
    set all [atomselect $new "not (water same residue as within 2.0 of protein)"] 
    $all  writepdb system.pdb 
    $all  writepsf system.psf
    $all delete
    
    autoionize -psf system.psf -pdb system.pdb  -neutralize   -o system_00
    
    set sys [mol new      system_00.psf]
    mol addfile  system_00.pdb

    set all [atomselect $sys all]
    set CAL [atomselect $sys "resname CAL"  ]
    set CAR [atomselect $sys "resname CAR"  ]
    set OXY [atomselect $sys "resname OXY"  ]
    $all set occupancy 0
    $CAL set occupancy 1
    $CAR set occupancy 1
    $OXY set occupancy 1
    $all writepdb system_00.pdb
    set center [measure  center $all]
    puts "Center: $center"
    $all  moveby [vecscale -1 $center]
    puts "Center: $center"
    $all delete
    $CAL delete
    $CAR delete
    $OXY delete
}




proc  select {} {
    set all [atomselect top all]
    set CAL [atomselect top "resname CAL"  ]
    set CAR [atomselect top "resname CAR"  ]
    set OXY [atomselect top "resname OXY"  ]
    $all set occupancy 0
    $CAL set occupancy 1
    $CAR set occupancy 1
    $OXY set occupancy 1
    $all writepdb system_00.pdb
    set center [measure  center $all]
    puts "Center: $center"
    $all  moveby [vecscale -1 $center]
    puts "Center: $center"
    $all delete

}

